#!<PATH_REMOVED> python3
import os
import random
import subprocess
import shutil

# We will produce 50 random instances total.
NUM_INSTANCES = 50

# Ranges for floors and passengers.
FLOORS_OPTIONS     = [4, 5]
PASSENGERS_OPTIONS = [10, 11, 12]


FAST_ELEVATORS  = 2
SLOW_ELEVATORS  = 1  
FAST_CAPACITY   = 2
SLOW_CAPACITY   = 1

# Where to store final .pddl files:
OUTDIR = ".<PATH_REMOVED>"

def compile_programs(floors, areasize):
        cflags_data = [
            "gcc", "-o", "generate_data", "generate_data.c",
            # Undefine these macros so that the built-in #defines do not conflict:
            "-U", "FLOORS",
            "-U", "AREA_SIZE",
            "-U", "FAST_ELEVATORS",
            "-U", "SLOW_ELEVATORS",
            "-U", "FAST_CAPACITY",
            "-U", "SLOW_CAPACITY",
            # Now define them how we want:
            "-D", f"FLOORS={floors}",
            "-D", f"AREA_SIZE={areasize}",
            "-D", f"FAST_ELEVATORS={FAST_ELEVATORS}",
            "-D", f"SLOW_ELEVATORS={SLOW_ELEVATORS}",
            "-D", f"FAST_CAPACITY={FAST_CAPACITY}",
            "-D", f"SLOW_CAPACITY={SLOW_CAPACITY}"
        ]
        subprocess.run(cflags_data)
        # For generate_pddl, you can just compile without -U/-D, or likewise undef & define
        cflags_pddl = [
            "gcc", "-o", "generate_pddl", "generate_pddl.c", "-lm"
        ]
        subprocess.run(cflags_pddl)

def main():
    # Create the output directory if it does not exist
    os.makedirs(OUTDIR, exist_ok=True)
    
    # First choose 50 random pairs (floors, passengers).
    # This way the final set is shuffled “up front.”
    chosen = []
    for _ in range(NUM_INSTANCES):
        f = random.choice(FLOORS_OPTIONS)
        p = f + 2#random.choice(PASSENGERS_OPTIONS)
        if f < 5: a = 2
        else: a = 3
        chosen.append((f, p, a))
    # Shuffle them so instance-1 is not necessarily “easiest.”
    random.shuffle(chosen)

    for i, (floors, passengers, areasize) in enumerate(chosen, start=1):
        # 1) Compile programs so that generate_data is built with
        #    FLOORS=<floors> (and other #defines).
        compile_programs(floors, areasize)

        # 2) Run generate_data to produce exactly ONE .txt file
        #    named p<floors>_<passengers>_1.txt, by setting
        #       MinPassengers=passengers,
        #       MaxPassengers=passengers,
        #       Step=1,
        #       MinID=1,
        #       MaxID=1.
        #    That yields p<floors>_<passengers>_1.txt.
        generate_data_cmd = [
            ".<PATH_REMOVED>",
            str(passengers), str(passengers), "1", "1", "1"
        ]
        subprocess.run(generate_data_cmd)
        
        # 3) Run generate_pddl so it reads that single .txt and
        #    converts it into p<floors>_<passengers>_1.pddl.
        #    Command line usage: generate_pddl floors1 floors2 floorsd
        #                        pass1   pass2   passd   minID   maxID
        #    Since we only have one file called p<floors>_<passengers>_1.txt,
        #    we pass floors1=floors2=floors, passengers1=passengers2=passengers,
        #    minID=1, maxID=1.
        generate_pddl_cmd = [
            ".<PATH_REMOVED>",
            str(floors), str(floors), "1",
            str(passengers), str(passengers), "1",
            "1", "1"
        ]
        subprocess.run(generate_pddl_cmd)
        
        # 4) The new PDDL file is p<floors>_<passengers>_1.pddl.
        #    Rename it to instance-{i}.pddl, then move it into OUTDIR.
        old_name = f"p{floors}_{passengers}_1.pddl"
        new_name = os.path.join(OUTDIR, f"instance-{i}.pddl")
        shutil.move(old_name, new_name)
        
        print(f"Generated {new_name} (floors={floors}, passengers={passengers}).")
    
    print("\nAll done! 50 instances have been created in", OUTDIR)

if __name__ == "__main__":
    main()